<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function ehm_admin_page_html() {
    wp_enqueue_style( 'dashicons' );

    $gradients = [
        1 => 'linear-gradient(45deg, #00f5a0, #00d1ff)', 
        2 => 'linear-gradient(45deg, #8e2de2, #4a00e0)', 
        3 => 'linear-gradient(45deg, #f09819, #ff512f)', 
        4 => 'linear-gradient(45deg, #38ef7d, #11998e)', 
        5 => 'linear-gradient(45deg, #2c5364, #203a43)', 
        6 => 'linear-gradient(45deg, #1a1a1a, #434343)', 
        7 => 'linear-gradient(45deg, #7f7fd5, #86a8e7)', 
        8 => 'linear-gradient(45deg, #ffc3a0, #ffafbd)', 
        9 => 'linear-gradient(45deg, #363795, #005c97)', 
        10 => 'linear-gradient(45deg, #bd3f32, #cb356b)',
        11 => 'linear-gradient(45deg, #bac8e0, #e0eafc)', 
        12 => 'linear-gradient(45deg, #2c3e50, #4ca1af)', 
        13 => 'linear-gradient(45deg, #0072ff, #00c6ff)', 
        14 => 'linear-gradient(45deg, #56ab2f, #a8e063)', 
        15 => 'linear-gradient(45deg, #e65c00, #f9d423)', 
        16 => 'linear-gradient(45deg, #2b5876, #4e4376)', 
        17 => 'linear-gradient(45deg, #bb377d, #ff708d)', 
        18 => 'linear-gradient(45deg, #ffcc33, #ffb347)', 
        19 => 'linear-gradient(45deg, #2a5298, #1e3c72)', 
        20 => 'linear-gradient(45deg, #2f0743, #41295a)',
        21 => 'linear-gradient(45deg, #0575e6, #021b79)', 
        22 => 'linear-gradient(45deg, #1f1f1f, #434343)', 
        23 => 'linear-gradient(45deg, #dce35b, #45b649)', 
        24 => 'linear-gradient(45deg, #ec008c, #fc6767)', 
        25 => 'linear-gradient(45deg, #5b86e5, #36d1dc)', 
        26 => 'linear-gradient(45deg, #1cefff, #0abfbc)', 
        27 => 'linear-gradient(45deg, #240b36, #c31432)', 
        28 => 'linear-gradient(45deg, #2c3e50, #3498db)', 
        29 => 'linear-gradient(45deg, #abbaab, #ffffff)', 
        30 => 'linear-gradient(45deg, #ff9a9e, #fad0c4)'
    ];
    $solid_colors = [
        31 => '#154734',
        32 => '#6a3460',
        33 => '#004851',
        34 => '#4b2d12',
        35 => '#8cc63f',
        36 => '#a52422',
        37 => '#007681',
        38 => '#f49f24',
        39 => '#6abf4b',
        40 => '#b5124f',
        41 => '#00b2dd',
        42 => '#ffcc00',
        43 => '#c4d600',
        44 => '#ff585d',
        45 => '#6dc5d9',
        46 => '#ffb300',
        47 => '#5171a5',
        48 => '#929497',
        49 => '#9fdaa7',
        50 => '#ffffff',
        51 => '#d0d3d4',
        52 => '#fbb040',
        53 => '#b6d0e2',
        54 => '#fbd93f',
        55 => '#000000', 
        56 => '#1a1a1a',
        57 => '#2c2c2c',
        58 => '#3d3d3d',
    ];
    $plugin_url = plugins_url('', dirname(__FILE__));
    ?>

    <div class="wrap ehm-admin-wrap">
        <h1>MrSeokar CTA Box</h1>
        <p>ساخت شورتکد <code>[ehm_box]</code> با پارامترهای دلخواه</p>

    <style>
        .ehm-preview-loader {
            display:flex;justify-content:center;align-items:center;height:160px;background:rgba(255,255,255,0.84);margin-bottom:0;
        }
        .ehm-spinner { width:42px;height:42px;display:inline-block;position:relative;}
        .ehm-spinner svg { width:100%;height:100%;display:block; }
        .ehm-spinner circle { stroke:#0073aa;stroke-width:4px;fill:none;stroke-linecap:round;stroke-dasharray:75 75;}
        .ehm-color-checkboxes {display: flex;flex-wrap: wrap;gap: 6px;}
        .ehm-color-box {cursor: pointer;}
        .ehm-color-box input {display: none;}
        .ehm-color-swatch {width:22px;height:22px;display:inline-block;border:1px solid rgba(0,0,0,0.4);border-radius:3px;transition:transform 0.15s;}
        .ehm-color-box input:checked + .ehm-color-swatch {outline:2px solid #000;transform:scale(1.2);}
        .ehm-icon-examples {margin-top:6px;}
        .ehm-icon-example {cursor:pointer;font-size:24px;padding:2px 8px;color:#555;transition:color 0.2s,box-shadow 0.2s;border-radius:4px;border:1px solid transparent;margin-left:3px;margin-right:3px;margin-bottom: 10px;vertical-align:middle;background:#f4f4f4;}
        .ehm-icon-example:hover, .ehm-icon-example.selected {color:#0073aa;border-color:#0073aa;background:#e1f5fe;box-shadow:0 2px 5px rgba(0,123,170,0.08);}
        .ehm-img-thumb {transition: box-shadow .14s,border .14s;}
        .ehm-img-thumb:hover {border-color:#0073aa !important;box-shadow:0 4px 12px rgba(0,123,170,0.14);}
        .ehm-img-thumb.selected {box-shadow:0 0 0 3px #0073aa !important;border-color:#0073aa !important;}
        .ehm-template-gallery {
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
            padding-bottom: 4px;
        }
        .ehm-template-card {
            display: inline-block;
            width: 170px;
            min-width: 90px;
            max-width: 175px;
            vertical-align: top;
            border: 2.5px solid #e0eafc;
            border-radius: 11px;
            box-shadow: 0 2px 12px rgba(70,130,180,0.05), 0 1px 2px rgba(0,0,0,0.03);
            background: #f5f8fa;
            text-align: center;
            cursor: pointer;
            transition: border .15s,box-shadow .15s,transform .14s;
            position: relative;
            padding: 7px 7px 10px 7px;
        }
        .ehm-template-card.selected, .ehm-template-card:hover {
            border-color: #2196f3;
            box-shadow: 0 4px 18px rgba(33,150,243,0.13);
            transform: scale(1.045);
            z-index: 1;
        }
        .ehm-template-card input[type=radio] { display: none; }
        .ehm-template-thumb {
            width: 100%;
            height: 54px;
            border-radius: 7px;
            margin-bottom: 7px;
            margin-top: 1px;
        }
        .ehm-template-number {
            font-weight: 700;
            font-size: 14px;
            background: #8e8e90;
            color: #fff;
            display:inline-block;
            border-radius: 11px 11px 11px 0;
            line-height:1;
            padding: 3px 12px 5px 9px;
            margin-bottom: 3.5px;
            letter-spacing: .7px;
        }
        .ehm-template-card.selected .ehm-template-number,
        .ehm-template-card:hover .ehm-template-number {
            background: #1769aa;
        }
        .form-table td p.description{font-size:11px;color: #aaa;}
    </style>

    <form id="ehm-generator-form" onsubmit="return false;">
        <table class="form-table">
            <tr>
                <th><label for="ehm-url">آدرس لینک کال تو اکشن</label></th>
                <td>
                    <input type="url" id="ehm-url" name="url" class="regular-text" placeholder="https://example.com/your-page">
                    <p class="description">هر لینکی از سایت خودتان یا سایت های دیگر را می توانید وارد کنید (مقاله، محصول، برگه، لینک دانلود، پیج اینستاگرام و...).</p>
                </td>
            </tr>
    
            <tr>
                <th>انتخاب قالب</th>
                <td>
                    <div class="ehm-template-gallery">
                        <?php
                        for ($i = 1; $i <= 10; $i++):
                            $img = $plugin_url . '/assets/img/tpl/tpl-' . $i . '.svg';
                        ?>
                        <label class="ehm-template-card" data-tpl="<?php echo $i; ?>">
                            <input type="radio" name="template" id="ehm-template-<?php echo $i; ?>" value="<?php echo $i; ?>" <?php echo $i === 1 ? 'checked' : ''; ?>>
                            <span class="ehm-template-number">قالب شماره <?php echo $i; ?></span>
                            <img loading="lazy" class="ehm-template-thumb" src="<?php echo esc_url($img); ?>" alt="قالب <?php echo $i; ?>">
                        </label>
                        <?php endfor; ?>
                    </div>
                    <input type="hidden" name="template" id="ehm-template" value="1">
                </td>
            </tr>
    
            <tr>
                <th>انتخاب رنگ و استایل</th>
                <td>
                    <div class="ehm-color-checkboxes">
                        <?php foreach ( $gradients as $num => $gradient ): ?>
                            <label class="ehm-color-box" title="Gradient <?php echo $num; ?>">
                                <input type="radio" name="color" value="<?php echo $num; ?>">
                                <span class="ehm-color-swatch" style="background: <?php echo $gradient; ?>"></span>
                            </label>
                        <?php endforeach; ?>
                        <?php foreach ( $solid_colors as $num => $color ): ?>
                            <label class="ehm-color-box" title="Color <?php echo $num; ?>">
                                <input type="radio" name="color" value="<?php echo $num; ?>">
                                <span class="ehm-color-swatch" style="background: <?php echo $color; ?>"></span>
                            </label>
                        <?php endforeach; ?>
                    </div>
                    <p class="description">روی رنگ مورد نظر خود کلیک کنید (فقط یک رنگ قابل انتخاب است).</p>
                </td>
            </tr>
    
            <tr>
                <th><label for="ehm-fetch">روش دریافت</label></th>
                <td>
                    <select id="ehm-fetch" name="fetch">
                        <option value="false">دستی (وارد کردن تمام اطلاعات)</option>
                        <option value="true">خودکار (واکشی هوشمند از لینک)</option>
                    </select>
                </td>
            </tr>
    
            <tr class="manual-fields">
                <th><label for="ehm-title">عنوان</label></th>
                <td>
                    <input type="text" id="ehm-title" name="title" class="regular-text" placeholder="عنوان دعوت به اقدام را وارد کنید...">
                </td>
            </tr>
    
            <tr class="manual-fields">
                <th><label for="ehm-desc">توضیحات</label></th>
                <td>
                    <textarea id="ehm-desc" name="description" rows="3" class="large-text" placeholder="یک توضیح کوتاه و جذاب در مورد لینک بنویسید..."></textarea>
                </td>
            </tr>
            <tr class="manual-fields">
                <th><label for="ehm-image">تصویر</label></th>
                <td>
                    <input type="url" id="ehm-image" name="image" class="regular-text" placeholder="لینک تصویر را اینجا جای گذاری کنید">
                    <div class="ehm-img-thumbs ehm-img-jpgs" style="margin-top:8px;display:none;flex-wrap:wrap;gap:6px;">
                        <?php
                        $img_base = $plugin_url . '/assets/img/';
                        $thumbs_base = $img_base . 'thumbs/';
                        for ( $i = 1; $i <= 20; $i++ ):
                            $thumb = $thumbs_base . "{$i}_thumb.jpg";
                            $full = $img_base . "{$i}.jpg";
                        ?>
                        <img src="<?php echo esc_url($thumb); ?>" data-full="<?php echo esc_url($full); ?>" title="تصویر <?php echo $i; ?>" alt="تصویر <?php echo $i; ?>" class="ehm-img-thumb" style="width:88px;height:44px;object-fit:cover;cursor:pointer;border-radius:3px;border:1px solid #ccd0d4;" loading="lazy">
                        <?php endfor; ?>
                    </div>
                    <div class="ehm-img-thumbs ehm-img-svgs" style="margin-top:8px;display:none;flex-wrap:wrap;gap:6px;">
                        <?php
                        $svg_base = $plugin_url . '/assets/img/svg/';
                        $svg_thumbs_base = $svg_base . 'thumbs/';
                        for ( $i = 1; $i <= 30; $i++ ):
                            $svg_thumb = $svg_thumbs_base . "{$i}_thumb.jpg";
                            $svg = $svg_base . "{$i}.svg";
                        ?>
                        <img src="<?php echo esc_url($svg_thumb); ?>" data-full="<?php echo esc_url($svg); ?>" title="SVG <?php echo $i; ?>" alt="SVG <?php echo $i; ?>" class="ehm-img-thumb" style="width:52px;height:52px;object-fit:contain;cursor:pointer;border-radius:5px;border:1px solid #ccd0d4;background:#fff;padding:6px;" loading="lazy">
                        <?php endfor; ?>
                    </div>
                    <p class="description">برای استفاده از تصاویر پیش فرض روی آن ها کلیک کنید، یا لینک تصویر دلخواه خود را در فیلد بالا وارد نمایید.</p>
                </td>
            </tr>
            <tr>
                <th><label for="ehm-cta-text">متن لینک CTA</label></th>
                <td>
                    <input type="text" id="ehm-cta-text" name="cta_text" class="regular-text" placeholder="مثلاً: مشاهده و دانلود">
                </td>
            </tr>
            <tr>
                <th><label for="ehm-icon">آیکون (Dashicons)</label></th>
                <td>
                    <input type="text" id="ehm-icon" name="icon" class="regular-text" placeholder="مثلاً dashicons-cart یا روی نمونه ها کلیک کنید" style="direction:ltr">
                    <div class="ehm-icon-examples" style="margin-top:6px;">
                        <span class="ehm-icon-example dashicons dashicons-phone" data-class="dashicons-phone" title="تلفن"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-left-alt2" data-class="dashicons-arrow-left-alt2" title="فلش چپ"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-right-alt2" data-class="dashicons-arrow-right-alt2" title="فلش راست"></span>
                        <span class="ehm-icon-example dashicons dashicons-cart" data-class="dashicons-cart" title="سبد خرید"></span>
                        <span class="ehm-icon-example dashicons dashicons-sos" data-class="dashicons-sos" title="اس اواس"></span>
                        <span class="ehm-icon-example dashicons dashicons-search" data-class="dashicons-search" title="جست وجو"></span>
                        <span class="ehm-icon-example dashicons dashicons-download" data-class="dashicons-download" title="دانلود"></span>
                        <span class="ehm-icon-example dashicons dashicons-pdf" data-class="dashicons-pdf" title="PDF"></span>
                        <span class="ehm-icon-example dashicons dashicons-admin-home" data-class="dashicons-admin-home" title="خانه"></span>
                        <span class="ehm-icon-example dashicons dashicons-controls-play" data-class="dashicons-controls-play" title="پخش"></span>
                        <span class="ehm-icon-example dashicons dashicons-saved" data-class="dashicons-saved" title="ذخیره شده"></span>
                        <span class="ehm-icon-example dashicons dashicons-info-outline" data-class="dashicons-info-outline" title="اطلاعات"></span>
                        <span class="ehm-icon-example dashicons dashicons-insert" data-class="dashicons-insert" title="درج"></span>
                        <span class="ehm-icon-example dashicons dashicons-admin-links" data-class="dashicons-admin-links" title="لینک"></span>
                        <span class="ehm-icon-example dashicons dashicons-editor-help" data-class="dashicons-editor-help" title="راهنما"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-left-alt" data-class="dashicons-arrow-left-alt" title="فلش چپ سادۀ قدیمی"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-right-alt" data-class="dashicons-arrow-right-alt" title="فلش راست سادۀ قدیمی"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-right" data-class="dashicons-arrow-right" title="فلش راست"></span>
                        <span class="ehm-icon-example dashicons dashicons-arrow-left" data-class="dashicons-arrow-left" title="فلش چپ"></span>
                        <span class="ehm-icon-example dashicons dashicons-instagram" data-class="dashicons-instagram" title="اینستاگرام"></span>
                        <span class="ehm-icon-example dashicons dashicons-star-filled" data-class="dashicons-star-filled" title="ستاره"></span>
                    </div>
                    <p class="description">
                        کلاس آیکون مورد نظر را وارد کنید یا روی نمونه ها کلیک کنید.<br>
                        <a href="https://developer.wordpress.org/resource/dashicons/" target="_blank" rel="noopener" style="color:#0073aa;font-weight:bold;text-decoration:underline;">
                            مشاهده تمام آیکون های Dashicons
                        </a>
                    </p>
                </td>
            </tr>
            <tr>
                <th>جایگاه آیکون در CTA</th>
                <td>
                    <select id="ehm-icon-pos" name="icon_position">
                        <option value="left">راست</option>
                        <option value="right">چپ</option>
                    </select>
                    <p class="description">محل قرارگیری آیکون در دکمه را مشخص کنید.</p>
                </td>
            </tr>
        </table>
        <p class="submit">
            <button type="button" class="button button-primary" id="ehm-generate-btn">تولید شورتکد و پیش نمایش</button>
            <button type="button" class="button" id="ehm-copy-btn" disabled>کپی شورتکد</button>
        </p>
        <div style="margin-top:20px;">
            <label for="ehm-shortcode-result">خروجی شورتکد:</label>
            <input type="text" id="ehm-shortcode-result" readonly class="large-text code" placeholder="شورتکد تولید شده در اینجا نمایش داده می شود...">
        </div>
        <h2 style="margin-top:40px;">پیش نمایش</h2>
        <div id="ehm-preview" style="border:1px solid #ddd; padding:20px; background:#f9f9f9; min-height: 150px; align-items: center; justify-content: center; color: #888;">
            برای مشاهده پیش نمایش، روی دکمه «تولید شورتکد و پیش نمایش» کلیک کنید.
        </div>
        <div id="ehm-preview-meta" style="display:none; margin-top:15px;"></div>
    </form>

    </div>

    <script>
    jQuery(function($){
        $('input[name="color"]').on('change', function(){
            $('input[name="color"]').not(this).prop('checked', false);
        });
        function toggleManualFields(){
            ($('#ehm-fetch').val()==='true') ? $('.manual-fields').hide() : $('.manual-fields').show();
        }
        $('#ehm-fetch').on('change',toggleManualFields);
        toggleManualFields();
        $('.ehm-icon-example').on('click',function(){
            $('.ehm-icon-example').removeClass('selected');
            $(this).addClass('selected');
            $('#ehm-icon').val($(this).data('class')).trigger('change');
        });

        $('.ehm-template-card input[type=radio]').on('change', function(){
            $('.ehm-template-card').removeClass('selected');
            $(this).closest('.ehm-template-card').addClass('selected');
            $('#ehm-template').val( $(this).val() ).trigger('change');
        });
        $('.ehm-template-card').on('click', function(e){
            $(this).find('input[type=radio]').prop('checked', true).trigger('change');
        });
        $('.ehm-template-card:eq(0)').addClass('selected');

        function toggleThumbsByTemplate() {
            var tpl = $('#ehm-template').val();
            if(tpl === '4' || tpl === '7') {
                $('.ehm-img-jpgs').show();
                $('.ehm-img-svgs').hide();
            } else {
                $('.ehm-img-jpgs').hide();
                $('.ehm-img-svgs').show();
            }
            $('.ehm-img-thumb').removeClass('selected');
        }
        $('#ehm-template').on('change', toggleThumbsByTemplate);
        toggleThumbsByTemplate();

        $(document).on('click', '.ehm-img-thumb', function(){
            $('#ehm-image').val( $(this).data('full') ).trigger('change');
            $('.ehm-img-thumb').removeClass('selected');
            $(this).addClass('selected');
        });

        function buildShortcode(){
            let sc='[ehm_box';
            sc += ' url="'+$('#ehm-url').val()+'"';
            sc += ' template="'+$('#ehm-template').val()+'"';
            let selectedColor=$('input[name="color"]:checked').val();
            if(selectedColor) sc += ' color="'+selectedColor+'"';
            sc += ' fetch="'+$('#ehm-fetch').val()+'"';
            if($('#ehm-cta-text').val()) sc += ' cta_text="'+$('#ehm-cta-text').val()+'"';
            if($('#ehm-icon').val()) sc += ' icon="'+$('#ehm-icon').val()+'"';
            if($('#ehm-icon-pos').val()) sc += ' icon_position="'+$('#ehm-icon-pos').val()+'"';
            if($('#ehm-fetch').val()==='false'){
                if($('#ehm-title').val()) sc += ' title="'+$('#ehm-title').val()+'"';
                if($('#ehm-desc').val()) sc += ' description="'+$('#ehm-desc').val()+'"';
                if($('#ehm-image').val()) sc += ' image="'+$('#ehm-image').val()+'"';
            }
            sc += ']';
            $('#ehm-shortcode-result').val(sc);
        }
        $('#ehm-generate-btn').on('click',function(){
            buildShortcode();
            $('#ehm-preview').html(
                '<div class="ehm-preview-loader">' +
                '<span class="ehm-spinner">' +
                '<svg viewBox="0 0 50 50"><circle cx="25" cy="25" r="20"><animateTransform attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.7s" repeatCount="indefinite"/></circle></svg>' +
                '</span></div>'
            );
            $.post(ajaxurl, {
                action: 'ehm_preview',
                url: $('#ehm-url').val(),
                template: $('#ehm-template').val(),
                color: $('input[name="color"]:checked').val() || '',
                fetch: $('#ehm-fetch').val(),
                title: $('#ehm-title').val(),
                description: $('#ehm-desc').val(),
                image: $('#ehm-image').val(),
                cta_text: $('#ehm-cta-text').val(),
                icon: $('#ehm-icon').val(),
                icon_position: $('#ehm-icon-pos').val()
            }, function(res){
                if(res.success) {
                    $('#ehm-preview').html(res.data.html || res.data);
                } else {
                    $('#ehm-preview').html('<span style="color:red;">خطا: '+res.data+'</span>');
                }
            });
        });
        $('#ehm-copy-btn').on('click',function(){
            let sc=$('#ehm-shortcode-result').val();
            if(!sc) return;
            navigator.clipboard.writeText(sc).then(()=>alert('کپی شد!'));
        });

    });
    </script>
    <?php
}
?>
