<?php if (!defined('ABSPATH')) exit; ?>
<?php    
$gradient_colors = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,23,24,25,26,27,28,29,30];
?>
<div class="ehm-bg-card ehm-color-<?php echo esc_attr($data['color']); ?> 
            <?php echo in_array($data['color'], $gradient_colors) ? 'gradient' : 'solid'; ?>
            <?php if (!empty($data['image'])) echo ' has-image'; ?>"
     <?php if (!empty($data['image'])): ?>
         style="--bg-img: url('<?php echo esc_url($data['image']); ?>')"
     <?php endif; ?>>

    <div class="ehm-overlay ehm-flex"> 
        
        <?php if (!empty($data['image'])): ?>
        <div class="ehm-column ehm-image-col">
            <img src="<?php echo esc_url($data['image']); ?>"
                 alt="<?php echo esc_attr($data['title']); ?>"
                 class="ehm-product-image" />
        </div>
        <?php endif; ?>

        <div class="ehm-column ehm-content-col">
            <?php if (!empty($data['title'])): ?>
                <h3><?php echo esc_html($data['title']); ?></h3>
            <?php endif; ?>

            <p>
                <?php
                if (!empty($data['description'])) {
                    echo esc_html($data['description']);
                } elseif (!empty($data['desc'])) {
                    echo esc_html($data['desc']);
                }
                ?>
            </p>

            <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
                <a href="<?php echo esc_url($data['permalink']); ?>"
                   class="ehm-cta-button"
                   target="_blank"
                   rel="noopener">
                    <?php
                    if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                        <span class="dashicons <?php echo esc_attr($data['icon']); ?>"
                              style="vertical-align:middle; margin-right:5px;"></span>
                    <?php endif; ?>

                    <?php echo esc_html($data['cta_text']); ?>

                    <?php
                    if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                        <span class="dashicons <?php echo esc_attr($data['icon']); ?>"
                              style="vertical-align:middle; margin-left:5px;"></span>
                    <?php endif; ?>
                </a>
            <?php endif; ?>
        </div>

    </div>
</div>
