<?php if (!defined('ABSPATH')) exit; ?>
<div class="ehm-hover-card ehm-color-<?php echo esc_attr($data['color']); ?>">

    <div class="ehm-text">
        <?php if (!empty($data['title'])): ?>
            <h3><?php echo esc_html($data['title']); ?></h3>
        <?php endif; ?>

        <p>
            <?php
            if (!empty($data['description'])) {
                echo esc_html($data['description']);
            } elseif (!empty($data['desc'])) {
                echo esc_html($data['desc']);
            }
            ?>
        </p>

        <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
            <a href="<?php echo esc_url($data['permalink']); ?>" class="ehm-cta-button" target="_blank" rel="noopener">
                <?php if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                    <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-right:5px;"></span>
                <?php endif; ?>
                
                <?php echo esc_html($data['cta_text']); ?>
                
                <?php if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                    <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-left:5px;"></span>
                <?php endif; ?>
            </a>
        <?php endif; ?>
    </div>
    <?php if (!empty($data['image'])): ?>
        <div class="ehm-img-zoom">
            <img src="<?php echo esc_url($data['image']); ?>" alt="<?php echo esc_attr($data['title']); ?>">
        </div>
    <?php endif; ?>
</div>
