<?php if (!defined('ABSPATH')) exit; ?>
<div class="ehm-timeline-item ehm-color-<?php echo esc_attr($data['color']); ?>">

    <div class="ehm-timeline-content" style="display:flex; gap:20px; align-items:center;">
        <div class="ehm-col ehm-col-image" 
             style="flex:0 0 auto;<?php if (!empty($data['image'])) {
                 echo '--ehm-bg:url(' . esc_url($data['image']) . ');';
             } ?>">
            <?php if (!empty($data['image'])): ?>
                <img src="<?php echo esc_url($data['image']); ?>" alt="<?php echo esc_attr($data['title']); ?>" style="max-width:100px; height:auto;">
            <?php endif; ?>
        </div>

        <div class="ehm-col ehm-col-title" style="flex:0 0 auto;">
            <?php if (!empty($data['title'])): ?>
                <h4><?php echo esc_html($data['title']); ?></h4>
            <?php endif; ?>
        </div>

        <div class="ehm-col ehm-col-description" style="flex:1;">
            <?php
            $text_source = '';
            if (!empty($data['description'])) {
                $text_source = $data['description'];
            } elseif (!empty($data['desc'])) {
                $text_source = $data['desc'];
            }
            if (!empty($text_source)): ?>
                <p><?php echo esc_html($text_source); ?></p>
            <?php endif; ?>
        </div>

        <div class="ehm-col ehm-col-button" style="flex:0 0 auto;">
            <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
                <a href="<?php echo esc_url($data['permalink']); ?>" class="ehm-cta-button" target="_blank" rel="noopener">
                    <?php if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                        <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-right:5px;"></span>
                    <?php endif; ?>
                    
                    <?php echo esc_html($data['cta_text']); ?>
                    
                    <?php if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                        <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-left:5px;"></span>
                    <?php endif; ?>
                </a>
            <?php endif; ?>
        </div>

    </div>
</div>
