<?php
/*
Plugin Name: MrSeokar CTA Box
Plugin URI: https://ehm.ir/cta-box/
Description: تولید باکس هوشمند دعوت به اقدام (CTA) با قابلیت دریافت داده از JSON محصولات (همراه قیمت)، مقالات یا سایت خارجی + 10 قالب مدرن و 30 تم رنگی Web3 + دکمه دعوت به اقدام
Version: 1.0
Author: Ebrahim Hanafi (مسترسئوکار)
Author URI: https://ehm.ir
Text Domain: mrseokar-box
License: GPLv2 or later
*/

if ( ! defined( 'ABSPATH' ) ) exit; 

define('ehm_PATH', plugin_dir_path(__FILE__));
define('ehm_URL', plugin_dir_url(__FILE__));

require_once ehm_PATH . 'includes/class-json-fetch.php';

add_action('wp_enqueue_scripts', function(){
    wp_enqueue_style('ehm-templates', ehm_URL . 'assets/css/templates.css', [], '1.0');
    wp_enqueue_style('ehm-colors', ehm_URL . 'assets/css/colors.css', [], '1.0');
    wp_enqueue_style('dashicons'); 
});

add_action('admin_menu', function(){
    add_menu_page(
        'MrSeokar CTA Box Generator',
        'MrSeokar Box', 
        'manage_options', 
        'ehm-box', 
        'ehm_admin_page_html', 
        'dashicons-screenoptions',   
        30
    );
});

require_once ehm_PATH . 'admin/admin-ui.php';

if ( is_admin() ) {
    require_once ehm_PATH . 'admin/ajax-preview.php';
}

function ehm_admin_assets($hook) {
    if ($hook !== 'toplevel_page_ehm-box') {
        return;
    }

    wp_enqueue_style('ehm-admin-css', ehm_URL . 'admin/admin.css');
    wp_enqueue_script('ehm-admin-js', ehm_URL . 'assets/js/admin.js', array('jquery'), false, true);
    wp_enqueue_style('ehm-templates-css', ehm_URL . 'assets/css/templates.css');
    wp_enqueue_style('ehm-colors-css', ehm_URL . 'assets/css/colors.css');
    wp_enqueue_style('dashicons'); 
}
add_action('admin_enqueue_scripts', 'ehm_admin_assets');

add_shortcode('ehm_box', function($atts){
    $atts = shortcode_atts([
        'url'           => '',
        'template'      => '1',
        'color'         => '1',
        'fetch'         => 'true',
        'title'         => '',
        'description'   => '',
        'image'         => '',
        'type'          => '',
        'price'         => '',
        'regular_price' => '', 
        'sale_price'    => '', 
        'cta_text'      => '',
        'icon'          => '',    
        'icon_position' => 'right' 
    ], $atts);

    $template      = max(1, intval($atts['template']));
    $color         = max(1, intval($atts['color']));
    $icon          = sanitize_text_field($atts['icon']);
    $icon_position = in_array($atts['icon_position'], ['left','right']) ? $atts['icon_position'] : 'right';

    if ($atts['fetch'] === 'true' && !empty($atts['url'])) {
        $data = ehm_fetch_data($atts['url']);

        if (empty($data['permalink'])) {
            $data['permalink'] = esc_url_raw($atts['url']);
        }

        if (!empty($atts['cta_text'])) {
            $data['cta_text'] = sanitize_text_field($atts['cta_text']);
        } elseif (!isset($data['cta_text'])) {
            $data['cta_text'] = '';
        }

        $data['color']         = $color;
        $data['icon']          = $icon;
        $data['icon_position'] = $icon_position;

    } else {
        $data = [
            'title'         => sanitize_text_field($atts['title']),
            'description'   => sanitize_textarea_field($atts['description']),
            'image'         => esc_url_raw($atts['image']),
            'type'          => sanitize_text_field($atts['type']),
            'price'         => sanitize_text_field($atts['price']),
            'regular_price' => sanitize_text_field($atts['regular_price']),
            'sale_price'    => sanitize_text_field($atts['sale_price']),
            'permalink'     => esc_url_raw($atts['url']),
            'source'        => 'manual',
            'cta_text'      => sanitize_text_field($atts['cta_text']),
            'color'         => $color,
            'icon'          => $icon,
            'icon_position' => $icon_position
        ];
    }

    $required_keys = [
        'title',
        'description',
        'image',
        'type',
        'price',
        'regular_price',
        'sale_price',
        'permalink',
        'source',
        'cta_text',
        'color',
        'icon',
        'icon_position'
    ];
    foreach ($required_keys as $key) {
        if (!isset($data[$key])) {
            $data[$key] = '';
        }
    }

    $atts_for_template = [
        'template'      => $template,
        'color'         => $color,
        'cta_text'      => $data['cta_text'],
        'icon'          => $data['icon'],
        'icon_position' => $data['icon_position']
    ];

    ob_start();
    $template_file = ehm_PATH . "includes/templates/template{$template}.php";
    if (file_exists($template_file)) {
        include $template_file;
    } else {
        echo '<div class="ehm-error">Template not found.</div>';
    }
    return ob_get_clean();
});
